﻿/****** Object:  View [hips].[MonitoringPcehrUploadErrors]    Script Date: 07/12/2013 10:22:59 ******/
IF  EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[hips].[MonitoringPcehrUploadErrors]'))
DROP VIEW [hips].[MonitoringPcehrUploadErrors]
GO

/****** Object:  View [hips].[MonitoringPcehrUploadErrors]    Script Date: 07/12/2013 10:22:59 ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

CREATE VIEW [hips].[MonitoringPcehrUploadErrors]
AS
	SELECT 
		hp.Mrn as 'Patient MRN',
        SUBSTRING(pmi.Ihi, 1, 4) + ' '
        + SUBSTRING(pmi.Ihi, 4, 4) + ' '
        + SUBSTRING(pmi.Ihi, 8, 4) + ' '
        + SUBSTRING(pmi.Ihi, 12, 4) "IHI" ,
        ihis.Description "IHI Status" ,
		h.Description AS 'Hospital',
		e.AdmissionDate AS 'Episode Admission Date',
		pm.PatientMasterId,
		pmq.EpisodeId,
		pmq.PcehrMessageQueueId,
		pmq.DateCreated,
		pmq.Details AS 'Error Details'
		FROM  hips.PcehrMessageQueue pmq WITH (NOLOCK) 
		JOIN hips.Episode e WITH (NOLOCK) ON e.EpisodeId = pmq.EpisodeId
		JOIN hips.HospitalPatient hp WITH (NOLOCK) ON hp.PatientId = e.PatientId
		JOIN hips.Hospital h WITH (NOLOCK) ON hp.HospitalId = h.HospitalId
		JOIN hips.HealthProviderOrganisation hpo WITH (NOLOCK) ON h.HealthProviderOrganisationId = hpo.HealthProviderOrganisationId
		JOIN hips.PatientMaster pm WITH (NOLOCK) ON pm.PatientMasterId = hp.PatientMasterId 
		JOIN hips.PatientMasterIhi pmi WITH (NOLOCK) ON pm.PatientMasterId = pmi.PatientMasterId AND hpo.HealthProviderOrganisationNetworkId = pmi.HealthProviderOrganisationNetworkId
		JOIN hips.PatientMasterName pmn WITH (NOLOCK) ON pmn.PatientMasterId = pm.PatientMasterId and NameTypeId = 2
		JOIN hips.IhiStatus ihis WITH (NOLOCK) ON ihis.IhiStatusId = pmi.IhiStatusId
		LEFT JOIN hips.ClinicalDocument cd WITH (NOLOCK) ON cd.EpisodeId = e.EpisodeId
		LEFT JOIN hips.ClinicalDocumentVersion cdv WITH (NOLOCK) ON cd.ClinicalDocumentId = cdv.ClinicalDocumentId
		WHERE QueueStatusId = 3
		AND (cdv.UploadedDate IS NULL OR cdv.UploadedDate < pmq.DateCreated)
GO